<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/MarkUp/Wilbur/HTML32.dtd"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:html="http://www.w3.org/MarkUp/Wilbur/HTML32.dtd"
                              xmlns:wwindex="urn:WebWorks-Index-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwindex wwlinks wwmode wwfiles wwdoc wwsplits wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterProjectSplitsType" />
 <xsl:param name="ParameterMergePageType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterMergeType" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterTOCSplitFileType" />
 <xsl:param name="ParameterIndexSplitFileType" />
 <xsl:param name="ParameterPageTemplateURI" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />
 <xsl:param name="ParameterMergeCategory" />
 <xsl:param name="ParameterMergeUse" />
 <xsl:param name="ParameterMergeDeploy" />


 <xsl:output encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />
 <xsl:strip-space elements="*" />


 <xsl:include href="wwtransform:common/pages/pagetemplate.xsl" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <!-- Page Template -->
 <!--               -->
 <xsl:variable name="GlobalPageTemplatePath" select="wwuri:AsFilePath($ParameterPageTemplateURI)" />
 <xsl:variable name="GlobalPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalPageTemplatePath)" />


 <!-- Project Splits -->
 <!--                -->
 <xsl:variable name="GlobalProjectSplitsPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterProjectSplitsType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectSplits" select="wwexsldoc:LoadXMLWithoutResolver($GlobalProjectSplitsPath)" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Generate Index? -->
   <!--                 -->
   <xsl:if test="wwprojext:GetFormatSetting('index-generate', 'true') = 'true'">
    <!-- Iterate input documents -->
    <!--                         -->
    <xsl:for-each select="$GlobalFiles[1]">
     <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-type', $ParameterDependsType)" />

     <xsl:variable name="VarProgressGroupsAndMergeStart" select="wwprogress:Start(count($VarFilesByType) + 1)" />

     <xsl:for-each select="$VarFilesByType">
      <xsl:variable name="VarProgressGroupIndexStart" select="wwprogress:Start(1)" />

      <xsl:variable name="VarFilesDocument" select="." />

      <!-- Load splits -->
      <!--             -->
      <xsl:variable name="VarFilesSplits" select="key('wwfiles-files-by-groupid-type', concat($VarFilesDocument/@groupID, ':', $ParameterSplitsType))[1]" />
      <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesSplits/@path)" />

      <xsl:for-each select="$VarSplits[1]">
       <!-- Split -->
       <!--       -->
       <xsl:variable name="VarSplit" select="key('wwsplits-files-by-groupid-type', concat($VarFilesDocument/@groupID, ':', $ParameterIndexSplitFileType))[1]" />

       <!-- Transform -->
       <!--           -->
       <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarSplit/@path, '', $VarFilesDocument/@groupID, $VarFilesDocument/@documentID, $GlobalActionChecksum)" />
       <xsl:if test="not($VarUpToDate)">
        <xsl:variable name="VarResultAsXML">
         <!-- Conditions -->
         <!--            -->
         <xsl:variable name="VarConditionsAsXML">
          <!-- No conditions defined -->
          <!--                       -->
         </xsl:variable>
         <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

         <!-- Replacements -->
         <!--              -->
         <xsl:variable name="VarReplacementsAsXML">
          <!-- Content -->
          <!--         -->
          <wwpage:Replacement name="content">
           <!-- Load document -->
           <!--               -->
           <xsl:variable name="VarIndex" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesDocument/@path)" />

           <xsl:call-template name="Index">
            <xsl:with-param name="ParamSplits" select="$VarSplits" />
            <xsl:with-param name="ParamIndex" select="$VarIndex" />
            <xsl:with-param name="ParamSplit" select="$VarSplit" />
           </xsl:call-template>
          </wwpage:Replacement>
         </xsl:variable>
         <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

         <!-- Output directory path -->
         <!--                       -->
         <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetGroupName($VarSplit/@groupID))" />

         <!-- Invoke page template -->
         <!--                      -->
         <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
          <xsl:with-param name="ParamOutputDirectoryPath" select="$VarOutputDirectoryPath" />
          <xsl:with-param name="ParamOutputPath" select="$VarSplit/@path" />
          <xsl:with-param name="ParamConditions" select="$VarConditions" />
          <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
         </xsl:apply-templates>
        </xsl:variable>
        <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
        <xsl:variable name="VarEncoding" select="wwunits:EncodingFromCodePage($GlobalLocale/wwlocale:Locale/@codepage)" />
        <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarSplit/@path, $VarEncoding, 'html', '3.2', 'yes', 'yes', '', '-//IETF//DTD HTML//EN', '', '', 'text/html')" />
       </xsl:if>

       <!-- Report Files -->
       <!--              -->
       <wwfiles:File path="{$VarSplit/@path}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarSplit/@path)}" projectchecksum="" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
        <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
        <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
        <wwfiles:Depends path="{$VarFilesSplits/@path}" checksum="{$VarFilesSplits/@checksum}" groupID="{$VarFilesSplits/@groupID}" documentID="{$VarFilesSplits/@documentID}" />
        <wwfiles:Depends path="{$VarFilesDocument/@path}" checksum="{$VarFilesDocument/@checksum}" groupID="{$VarFilesDocument/@groupID}" documentID="{$VarFilesDocument/@documentID}" />
       </wwfiles:File>
      </xsl:for-each>

      <xsl:variable name="VarProgressGroupIndexEnd" select="wwprogress:End()" />
     </xsl:for-each>

     <!-- Merge -->
     <!--       -->
     <xsl:variable name="VarProgressMergeStart" select="wwprogress:Start(1)" />
     <xsl:if test="count($GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group) &gt; 1">
      <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />

      <xsl:variable name="VarMergePath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), concat(wwprojext:GetFormatName(), '.hhk'))" />

      <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarMergePath, concat($GlobalProject/wwproject:Project/@ChangeID, ':', count($VarProjectGroups)), '', '', $GlobalActionChecksum)" />
      <xsl:if test="not($VarUpToDate)">
       <xsl:variable name="VarResultAsXML">
        <!-- Conditions -->
        <!--            -->
        <xsl:variable name="VarConditionsAsXML">
         <!-- No conditions defined -->
         <!--                       -->
        </xsl:variable>
        <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

        <!-- Replacements -->
        <!--              -->
        <xsl:variable name="VarReplacementsAsXML">
         <!-- Content -->
         <!--         -->
         <wwpage:Replacement name="content">
          <xsl:call-template name="MergeIndex">
           <xsl:with-param name="ParamPath" select="$VarMergePath" />
          </xsl:call-template>
         </wwpage:Replacement>
        </xsl:variable>
        <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

        <!-- Invoke page template -->
        <!--                      -->
        <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
         <xsl:with-param name="ParamOutputDirectoryPath" select="wwprojext:GetTargetOutputDirectoryPath()" />
         <xsl:with-param name="ParamOutputPath" select="$VarMergePath" />
         <xsl:with-param name="ParamConditions" select="$VarConditions" />
         <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
        </xsl:apply-templates>
       </xsl:variable>
       <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />
       <xsl:variable name="VarEncoding" select="wwunits:EncodingFromCodePage($GlobalLocale/wwlocale:Locale/@codepage)" />
       <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarMergePath, $VarEncoding, 'html', '3.2', 'yes', 'yes', '', '-//IETF//DTD HTML//EN', '', '', 'text/html')" />
      </xsl:if>

      <wwfiles:File path="{$VarMergePath}" type="{$ParameterMergeType}" checksum="{wwfilesystem:GetChecksum($VarMergePath)}" projectchecksum="{concat($GlobalProject/wwproject:Project/@ChangeID, ':', count($VarProjectGroups))}" groupID="" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterMergeCategory}" use="{$ParameterMergeUse}" deploy="{$ParameterMergeDeploy}">
       <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
       <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
       <wwfiles:Depends path="{$GlobalProjectSplitsPath}" checksum="{wwfilesystem:GetChecksum($GlobalProjectSplitsPath)}" groupID="" documentID="" />
      </wwfiles:File>
     </xsl:if>
     <xsl:variable name="VarProgressMergeEnd" select="wwprogress:End()" />

     <xsl:variable name="VarProgressGroupsAndMergeEnd" select="wwprogress:End()" />
    </xsl:for-each>
   </xsl:if>

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="NewLine">
  <xsl:text>
</xsl:text>
 </xsl:template>


 <xsl:template name="Index">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamIndex" />
  <xsl:param name="ParamSplit" />

  <xsl:call-template name="NewLine" />

  <xsl:call-template name="Sections">
   <xsl:with-param name="ParamSplits" select="$ParamSplits" />
   <xsl:with-param name="ParamSplit" select="$ParamSplit" />
   <xsl:with-param name="ParamIndex" select="$ParamIndex/wwindex:Index" />
   <xsl:with-param name="ParamIndent" select="'    '" />
  </xsl:call-template>

  <xsl:text>  </xsl:text>
 </xsl:template>


 <xsl:template name="Sections">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamIndex" />
  <xsl:param name="ParamIndent" />

  <xsl:for-each select="$ParamIndex/wwindex:Section">
   <xsl:variable name="VarSection" select="." />

   <xsl:value-of select="$ParamIndent" />
   <html:ul>
   <xsl:call-template name="NewLine" />
    <xsl:variable name="VarIndent">
     <xsl:value-of select="$ParamIndent" />
     <xsl:text>  </xsl:text>
    </xsl:variable>

    <xsl:call-template name="Groups">
     <xsl:with-param name="ParamSplits" select="$ParamSplits" />
     <xsl:with-param name="ParamSplit" select="$ParamSplit" />
     <xsl:with-param name="ParamSection" select="$VarSection" />
     <xsl:with-param name="ParamIndent" select="$VarIndent" />
    </xsl:call-template>
   <xsl:value-of select="$ParamIndent" />
   </html:ul>
   <xsl:call-template name="NewLine" />
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Groups">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamSection" />
  <xsl:param name="ParamIndent" />

  <xsl:for-each select="$ParamSection/wwindex:Group">
   <xsl:variable name="VarGroup" select="." />

   <xsl:call-template name="Entries">
    <xsl:with-param name="ParamSplits" select="$ParamSplits" />
    <xsl:with-param name="ParamSplit" select="$ParamSplit" />
    <xsl:with-param name="ParamParent" select="$VarGroup" />
    <xsl:with-param name="ParamIndent" select="$ParamIndent" />
   </xsl:call-template>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="Entries">
  <xsl:param name="ParamSplits" />
  <xsl:param name="ParamSplit" />
  <xsl:param name="ParamParent" />
  <xsl:param name="ParamIndent" />

  <xsl:for-each select="$ParamParent/wwindex:Entry">

   <xsl:variable name="VarEntry" select="." />

   <xsl:variable name="VarSee" select="$VarEntry/wwindex:See[1]" />

   <xsl:choose>
    <xsl:when test="count($VarSee) = 1">
     <!-- See/See Also -->
     <!--              -->
     <xsl:value-of select="$ParamIndent" />
     <wwexsldoc:LessThan />li<wwexsldoc:GreaterThan />
     <html:object type="text/sitemap">
     <xsl:call-template name="NewLine" />
      <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
      <html:param name="Name">
       <xsl:attribute name="value">
        <xsl:call-template name="Content">
         <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
        </xsl:call-template>
       </xsl:attribute>
      </html:param>
      <xsl:call-template name="NewLine" />

      <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
      <xsl:call-template name="SeeAlsoParam">
       <xsl:with-param name="ParamSee" select="$VarEntry/wwindex:See[1]" />
      </xsl:call-template>
      <xsl:call-template name="NewLine" />

     <xsl:value-of select="$ParamIndent" /><xsl:text>    </xsl:text>
     </html:object>
     <xsl:call-template name="NewLine" />
    </xsl:when>

    <xsl:otherwise>
     <!-- Regular entry -->
     <!--               -->
     <xsl:variable name="VarLinks" select="$VarEntry/wwindex:Link" />

     <xsl:choose>
      <xsl:when test="count($VarLinks) = 0">
       <!-- Emit entry without any links -->
       <!--                              -->
       <xsl:value-of select="$ParamIndent" />
       <wwexsldoc:LessThan />li<wwexsldoc:GreaterThan />
       <html:object type="text/sitemap">
       <xsl:call-template name="NewLine" />

        <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
        <html:param name="Name">
         <xsl:attribute name="value">
          <xsl:call-template name="Content">
           <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
          </xsl:call-template>
         </xsl:attribute>
        </html:param>
        <xsl:call-template name="NewLine" />

        <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
        <html:param name="See Also">
         <xsl:attribute name="value">
          <xsl:call-template name="Content">
           <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
          </xsl:call-template>
         </xsl:attribute>
        </html:param>
        <xsl:call-template name="NewLine" />

       <xsl:value-of select="$ParamIndent" /><xsl:text>    </xsl:text>
       </html:object>
       <xsl:call-template name="NewLine" />
      </xsl:when>

      <xsl:when test="(count($VarLinks) = 1) and (count($VarLinks[1]/wwdoc:Content[1]) = 0)">
       <!-- Wrap link directly around entry -->
       <!--                                 -->
       <xsl:variable name="VarLink" select="$VarLinks[1]" />

       <xsl:value-of select="$ParamIndent" />
       <wwexsldoc:LessThan />li<wwexsldoc:GreaterThan />
       <html:object type="text/sitemap">
       <xsl:call-template name="NewLine" />
        <xsl:variable name="VarRelativeLinkPath" select="wwfilesystem:GetRelativeTo($VarLink/@href, $ParamSplit/@path)" />
        <xsl:variable name="VarLinkTitle" select="$ParamSplits/wwsplits:Splits/wwsplits:Split[@path = $VarLink/@href][1]/@title" />

        <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
        <html:param name="Name">
         <xsl:attribute name="value">
          <xsl:call-template name="Content">
           <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
          </xsl:call-template>
         </xsl:attribute>
        </html:param>
        <xsl:call-template name="NewLine" />

        <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
        <html:param name="Name" value="{$VarLinkTitle}" />
        <xsl:call-template name="NewLine" />

        <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
        <html:param name="Local">
         <xsl:attribute name="value">
          <xsl:value-of select="$VarRelativeLinkPath" />
          <xsl:text>#</xsl:text>
          <xsl:value-of select="$VarLink/@anchor" />
         </xsl:attribute>
        </html:param>
        <xsl:call-template name="NewLine" />

        <!-- Handle Window Type -->
        <!--                    -->
        <xsl:variable name="VarLinkSplit" select="$ParamSplits/wwsplits:Splits/wwsplits:Split[@path = $VarLink/@href][1]" />
        <xsl:if test="string-length($VarLinkSplit/@window-type) &gt; 0">
         <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
         <html:param name="WindowName" value="{$VarLinkSplit/@window-type}" />
         <xsl:call-template name="NewLine" />
        </xsl:if>

       <xsl:value-of select="$ParamIndent" /><xsl:text>    </xsl:text>
       </html:object>
       <xsl:call-template name="NewLine" />
      </xsl:when>

      <xsl:otherwise>
       <!-- Emit entry followed by links -->
       <!--                              -->
       <xsl:value-of select="$ParamIndent" />
       <wwexsldoc:LessThan />li<wwexsldoc:GreaterThan />
       <html:object type="text/sitemap">
       <xsl:call-template name="NewLine" />
        <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
        <html:param name="Name">
         <xsl:attribute name="value">
          <xsl:call-template name="Content">
           <xsl:with-param name="ParamContent" select="$VarEntry/wwdoc:Content[1]" />
          </xsl:call-template>
         </xsl:attribute>
        </html:param>
        <xsl:call-template name="NewLine" />

        <!-- Links -->
        <!--       -->
        <xsl:for-each select="$VarLinks">
         <xsl:variable name="VarLink" select="." />

         <xsl:variable name="VarRelativeLinkPath" select="wwfilesystem:GetRelativeTo($VarLink/@href, $ParamSplit/@path)" />
         <xsl:variable name="VarLinksLinkTitle" select="$ParamSplits/wwsplits:Splits/wwsplits:Split[@path = $VarLink/@href][1]/@title" />

         <xsl:choose>
          <xsl:when test="count($VarLink/wwdoc:Content[1]) = 1">
           <!-- Link has explicit text to show -->
           <!--                                -->
           <xsl:variable name="VarLinkSee" select="$VarLink/wwindex:See[1]" />
           <xsl:choose>
            <xsl:when test="count($VarLinkSee) = 1">
             <!-- See/See Also link redirect -->
             <!--                            -->

             <xsl:value-of select="$ParamIndent" /><xsl:text>        </xsl:text>
             <html:ul>
             <xsl:call-template name="NewLine" />

              <xsl:value-of select="$ParamIndent" /><xsl:text>          </xsl:text>
              <wwexsldoc:LessThan />li<wwexsldoc:GreaterThan />
              <html:object type="text/sitemap">
              <xsl:call-template name="NewLine" />
               <xsl:value-of select="$ParamIndent" /><xsl:text>            </xsl:text>
               <xsl:call-template name="SeeAlsoParam">
                <xsl:with-param name="ParamSee" select="$VarLink/wwindex:See[1]" />
               </xsl:call-template>
               <xsl:call-template name="NewLine" />

               <xsl:value-of select="$ParamIndent" /><xsl:text>            </xsl:text>
               <html:param name="Name" value="{$VarLinksLinkTitle}" />
               <xsl:call-template name="NewLine" />

               <xsl:value-of select="$ParamIndent" /><xsl:text>            </xsl:text>
               <xsl:if test="string-length($VarLinkSee/@entryID) &gt; 0">
                <html:param name="See Also">
                 <xsl:attribute name="value">
                  <xsl:text>#</xsl:text>
                  <xsl:value-of select="$VarLinkSee/@entryID" />
                 </xsl:attribute>
                </html:param>
               </xsl:if>
               <xsl:call-template name="NewLine" />

              <xsl:value-of select="$ParamIndent" /><xsl:text>          </xsl:text>
              </html:object>
              <xsl:call-template name="NewLine" />

             <xsl:value-of select="$ParamIndent" /><xsl:text>        </xsl:text>
             </html:ul>
             <xsl:call-template name="NewLine" />
            </xsl:when>

            <xsl:otherwise>
             <!-- Wrap link around content -->
             <!--                          -->
             <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
             <html:param name="See Also">
              <xsl:attribute name="value">
               <xsl:call-template name="Content">
                <xsl:with-param name="ParamContent" select="$VarLink/wwdoc:Content[1]" />
               </xsl:call-template>
              </xsl:attribute>
             </html:param>
             <xsl:call-template name="NewLine" />

             <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
             <html:param name="Local">
              <xsl:attribute name="value">
               <xsl:value-of select="$VarRelativeLinkPath" />
               <xsl:text>#</xsl:text>
               <xsl:value-of select="$VarLink/@anchor" />
              </xsl:attribute>
             </html:param>
             <xsl:call-template name="NewLine" />

             <!-- Handle Window Type -->
             <!--                    -->
             <xsl:variable name="VarLinkSplit" select="$ParamSplits/wwsplits:Splits/wwsplits:Split[@path = $VarLink/@href][1]" />
             <xsl:if test="string-length($VarLinkSplit/@window-type) &gt; 0">
              <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
              <html:param name="WindowName" value="{$VarLinkSplit/@window-type}" />
              <xsl:call-template name="NewLine" />
             </xsl:if>
            </xsl:otherwise>
           </xsl:choose>
          </xsl:when>

          <xsl:otherwise>
           <!-- Emit numbered entry -->
           <!--                     -->
           <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
           <html:param name="Name" value="{$VarLinksLinkTitle}" />
           <xsl:call-template name="NewLine" />

           <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
           <html:param name="Local">
            <xsl:attribute name="value">
             <xsl:value-of select="$VarRelativeLinkPath" />
             <xsl:text>#</xsl:text>
             <xsl:value-of select="$VarLink/@anchor" />
            </xsl:attribute>
           </html:param>
           <xsl:call-template name="NewLine" />

           <!-- Handle Window Type -->
           <!--                    -->
           <xsl:variable name="VarLinkSplit" select="$ParamSplits/wwsplits:Splits/wwsplits:Split[@path = $VarLink/@href][1]" />
           <xsl:if test="string-length($VarLinkSplit/@window-type) &gt; 0">
            <xsl:value-of select="$ParamIndent" /><xsl:text>      </xsl:text>
            <html:param name="WindowName" value="{$VarLinkSplit/@window-type}" />
            <xsl:call-template name="NewLine" />
           </xsl:if>
          </xsl:otherwise>
         </xsl:choose>
        </xsl:for-each>

       <xsl:value-of select="$ParamIndent" /><xsl:text>    </xsl:text>
       </html:object>
       <xsl:call-template name="NewLine" />
      </xsl:otherwise>
     </xsl:choose>
    </xsl:otherwise>
   </xsl:choose>

   <!-- Process children -->
   <!--                  -->
   <xsl:for-each select="$VarEntry/wwindex:Entry[1]">

    <xsl:value-of select="$ParamIndent" />
    <html:ul>
    <xsl:call-template name="NewLine" />

     <xsl:variable name="VarIndent">
      <xsl:value-of select="$ParamIndent" />
      <xsl:text>  </xsl:text>
     </xsl:variable>

     <xsl:call-template name="Entries">
      <xsl:with-param name="ParamSplits" select="$ParamSplits" />
      <xsl:with-param name="ParamSplit" select="$ParamSplit" />
      <xsl:with-param name="ParamParent" select="$VarEntry" />
      <xsl:with-param name="ParamIndent" select="$VarIndent" />
     </xsl:call-template>

    <xsl:value-of select="$ParamIndent" />
    </html:ul>
    <xsl:call-template name="NewLine" />
   </xsl:for-each>
  </xsl:for-each>
 </xsl:template>


 <xsl:template name="SeeAlsoParam">
  <xsl:param name="ParamSee" />

  <xsl:variable name="VarSeeEntry" select="$ParamSee/@entry" />

  <xsl:variable name="VarSeeAlsoValue">
   <xsl:choose>
    <xsl:when test="string-length($VarSeeEntry) &gt; 0">
     <xsl:value-of select="$VarSeeEntry" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:value-of select="'-'" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:variable>

  <html:param name="See Also" value="{$VarSeeAlsoValue}" />
 </xsl:template>


 <xsl:template name="Content">
  <xsl:param name="ParamContent" />

  <!-- Simple processing for now -->
  <!--                           -->
  <xsl:value-of select="$ParamContent/wwdoc:TextRun/wwdoc:Text/@value" />
 </xsl:template>


 <xsl:template name="MergeIndex">
  <xsl:param name="ParamPath" />

  <xsl:variable name="VarMergePagePath">
   <xsl:for-each select="$GlobalFiles[1]">
    <xsl:value-of select="key('wwfiles-files-by-type', $ParameterMergePageType)[1]/@path" />
   </xsl:for-each>
  </xsl:variable>

  <xsl:call-template name="NewLine" />

  <xsl:value-of select="'    '" />
  <html:ul>
  <xsl:call-template name="NewLine" />

   <xsl:value-of select="'      '" />
   <wwexsldoc:LessThan />li<wwexsldoc:GreaterThan />
   <html:object type="text/sitemap">
   <xsl:call-template name="NewLine" />

   <xsl:value-of select="'            '" />
   <html:param name="Name" value="{$GlobalLocale/wwlocale:Locale/wwlocale:Strings/wwlocale:String[@name = 'RequiredIndexEntry']/@value}" />
   <xsl:call-template name="NewLine" />

   <xsl:value-of select="'            '" />
   <html:param name="Local" value="{wwfilesystem:GetRelativeTo($VarMergePagePath, $ParamPath)}" />
   <xsl:call-template name="NewLine" />

   <xsl:value-of select="'          '" />
   </html:object>
   <xsl:call-template name="NewLine" />

  <xsl:value-of select="'    '" />
  </html:ul>
  <xsl:call-template name="NewLine" />

  <xsl:text>  </xsl:text>
 </xsl:template>
</xsl:stylesheet>
